<?php  
require_once("lib/map.php");  

try {  
    // Get the URL parameters  
    $uri = $_SERVER['REQUEST_URI'];  
    $parts = explode('/', trim($uri, '/')); // Split the URI by '/' and remove leading/trailing slashes  

    // Check if we have the expected parameters  
    if (count($parts) === 4) { // Expecting map.php/x/y  
        $x = intval($parts[2]); // Second part is x  
        $y = intval($parts[3]); // Third part is y  
    } else {  
        throw new Exception("Invalid parameters");  
    }  

    $map = new Map('map.jpg');  
    $map->setBlipFolder('blips');  
    $map->createBlip(56, $x, $y);  
    $map->createText('folana.ir', -2800, 2800, 100, 'IranSans.ttf');  
    $map->render("jpeg", "mahdi.jpeg");  
} catch (Exception $e) {  
    error_log($e->getMessage());  
    echo "An error occurred: " . $e->getMessage();  
}  
?>